#pragma once

#include <fmod.hpp>
#include <fmod_errors.h>


class SoundManager
{
public:
    SoundManager();
    ~SoundManager();

    bool Init();
    void Update();

    bool PlaySound( const char* filePath );

    double GetTimeSec() const;
    bool SetTimeSec( double tim );

    float GetScaleFactor() const;
    bool SetScaleFactor( float factor );

    void UpdateBuffer(float* target, size_t size);


private:
    static const int ms_nSpectrumSize = 512;

    FMOD::System*    m_system;
    FMOD::Channel*   m_channel;
    FMOD::Sound*     m_sound;
    FMOD_TAG         m_tag;
    int              m_numtags, m_numtagsupdated, m_count;
    unsigned int     m_version;
    float            m_fOriginalFrequency;
    float            m_afSpectrum[ms_nSpectrumSize];
};

